NPC = {
	__index = {
		new = function(self, _r, _d, _file, _dir)

			local cols,rows = string.match(_file, "(%d+)x(%d+)")
			cols = tonumber(cols)
			rows = tonumber(rows)
			local dirs = {"Down", "Left", "Right", "Up"}

			self.Frames = {}

			for i=1,rows do
				local temp = {}

				for j=1,cols do
					temp[#temp+1] = { Frame=(j+(((i-1)*cols)))-1, Delay=SRT.SleepDuration}
				end

				self.Frames[dirs[i]] = temp
			end


			self.Tile ={
				r = _r,
				d = _d
			}
			self.Trigger = "PlayerInteraction"
			self.Dir = _dir or "Down"
			self.EventIndex = nil

			self.Actor = function(i)

				 return Def.Sprite{
					Texture=THEME:GetPathB("Overworld", "overlay/Sprites/NPCs/" .. _file ),
					InitCommand=function(subself)
						SRT.EventActors[i] = subself
						self.EventIndex = i
					end,
					LoadCommand=function(subself)
						subself:animate(0)

						-- align to left and v-middle
						subself:halign(0)
						subself:valign(0.5)

						-- initialize the position
						subself:x( _r * SRT.TileData.TileSize )
						subself:y( _d * SRT.TileData.TileSize )
						subself:z( -(SRT.TileData.Height.Tiles - self.Tile.d) )
						-- initialize the sprite state
						subself:SetStateProperties( self.Frames[self.Dir] )

						-- mark the MapData where the npc is standing as collidable
						SRT.TileData.CollisionTiles[self.Tile.d * SRT.TileData.Width.Tiles + self.Tile.r + 1] = 1
					end,
					UpdateSpriteFramesCommand=function(subself)
						subself:SetStateProperties( self.Frames[self.Dir] )
					end,
					RepositionCommand=function(subself)
						-- update the position
						subself:x( _r * ((SRT.TileData and SRT.TileData.TileSize) or 32) )
						subself:y( _d * ((SRT.TileData and SRT.TileData.TileSize) or 32) )
					end,
					WalkCommand=function(subself, params)

						subself:SetStateProperties( self.Frames[params.Dir] )
							:linear(params.Duration)
							:x(params.r * SRT.TileData.TileSize)
							:y(params.d * SRT.TileData.TileSize)
							:queuecommand("AnimationOff")

					end,
					AnimationOnCommand=cmd(animate,1),
					AnimationOffCommand=cmd(animate, 0; setstate, 0),
					TurnToFacePlayerCommand=function(subself)
						if SRT.Player.dir == "Left" then self.Dir = "Right"
						elseif SRT.Player.dir == "Right" then self.Dir = "Left"
						elseif SRT.Player.dir == "Down" then self.Dir = "Up"
						elseif SRT.Player.dir == "Up" then self.Dir = "Down"
						end

						subself:queuecommand("UpdateSpriteFrames")
					end,
					TurnRightCommand=function(subself)
						self.Dir = "Right"
						subself:queuecommand("UpdateSpriteFrames")
					end,
				}
			end

			self.Action = nil

			return self
		end
	}
}